import { useEffect, useRef } from 'react';
import isFunction from './shared/isFunction';
import createHandlerSetter from './factory/createHandlerSetter';
/**
 * Returns a callback setter for a function to be performed when the component did mount.
 */
const useDidMount = (callback) => {
    const mountRef = useRef(false);
    const [handler, setHandler] = createHandlerSetter(callback);
    useEffect(() => {
        if (isFunction(handler === null || handler === void 0 ? void 0 : handler.current) && !mountRef.current) {
            handler.current();
            mountRef.current = true;
        }
    }, []);
    return setHandler;
};
export default useDidMount;
