import { useState } from 'react';
import useDragEvents from './useDragEvents';
const defaultOptions = {
    dragImageXOffset: 0,
    dragImageYOffset: 0,
    transferFormat: 'text'
};
const useDrag = (targetRef, options = defaultOptions) => {
    const { onDragStart, onDragEnd } = useDragEvents(targetRef, true);
    const [isDragging, setIsDragging] = useState(false);
    const opts = Object.assign(Object.assign({}, defaultOptions), (options || {}));
    onDragStart((event) => {
        var _a, _b, _c;
        setIsDragging(true);
        if (opts.dragImage && event.dataTransfer) {
            const img = new Image();
            img.src = opts.dragImage;
            event.dataTransfer.setDragImage(img, (_a = opts.dragImageXOffset) !== null && _a !== void 0 ? _a : 0, (_b = opts.dragImageYOffset) !== null && _b !== void 0 ? _b : 0);
        }
        if (opts.transfer && event.dataTransfer) {
            const data = typeof opts.transfer === 'object' ? JSON.stringify(opts.transfer) : `${opts.transfer}`;
            event.dataTransfer.setData((_c = opts.transferFormat) !== null && _c !== void 0 ? _c : 'text', data);
        }
    });
    onDragEnd(() => {
        setIsDragging(false);
    });
    return isDragging;
};
export default useDrag;
