import useEvent from './useEvent';
import isClient from './shared/isClient';
import noop from './shared/noop';
/**
 * Accepts an event name then returns a callback setter for a function to be performed when the event triggers.
 */
const useGlobalEvent = (eventName, opts) => {
    if (!isClient) {
        return noop;
    }
    const target = { current: window }; // that's a bit of a hack but it works
    return useEvent(target, eventName, opts);
};
export default useGlobalEvent;
