import useEvent from './useEvent';
/**
 * Returns a frozen object of callback setters to handle the mouse events.<br/>
 * It accepts a DOM ref representing the events target. <br/>
 * If a target is not provided the events will be globally attached to the document object.
 * <br/>
 * ### Shall the `useMouseEvents` callbacks replace the standard mouse handler props?
 *
 * **They shall not!**<br />
 * **useMouseEvents is meant to be used to abstract more complex hooks that need to control mouse**, for instance:
 * a drag n drop hook.<br />
 * Using useMouseEvents handlers instead of the classic props approach it's just as bad as it sounds since you'll
 * lose the React SyntheticEvent performance boost.<br />
 * If you were doing something like the following:
 */
const useMouseEvents = (targetRef, passive) => {
    const target = targetRef !== null && targetRef !== void 0 ? targetRef : { current: window.document };
    const onMouseDown = useEvent(target, 'mousedown', { passive });
    const onMouseEnter = useEvent(target, 'mouseenter', { passive });
    const onMouseLeave = useEvent(target, 'mouseleave', { passive });
    const onMouseMove = useEvent(target, 'mousemove', { passive });
    const onMouseOut = useEvent(target, 'mouseout', { passive });
    const onMouseOver = useEvent(target, 'mouseover', { passive });
    const onMouseUp = useEvent(target, 'mouseup', { passive });
    return Object.freeze({
        onMouseDown,
        onMouseEnter,
        onMouseLeave,
        onMouseMove,
        onMouseOut,
        onMouseOver,
        onMouseUp
    });
};
export default useMouseEvents;
