import { useEffect, useRef } from "react";
import isFunction from "./shared/isFunction";
import createHandlerSetter from "./factory/createHandlerSetter";
/**
 * Returns a callback setter for a callback to be performed when the component did unmount.
 */
const useUnmount = (callback) => {
    const mountRef = useRef(false);
    const [handler, setHandler] = createHandlerSetter(callback);
    useEffect(() => {
        mountRef.current = true;
        return () => {
            if (isFunction(handler === null || handler === void 0 ? void 0 : handler.current) && mountRef.current) {
                handler.current();
            }
        };
    }, []);
    return setHandler;
};
export default useUnmount;
