"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
var react_1 = require("react");
var safelyParseJson_1 = __importDefault(require("../shared/safelyParseJson"));
var isClient_1 = __importDefault(require("../shared/isClient"));
var isAPISupported_1 = __importDefault(require("../shared/isAPISupported"));
var isDevelopment_1 = __importDefault(require("../shared/isDevelopment"));
var noop_1 = __importDefault(require("../shared/noop"));
var warnOnce_1 = __importDefault(require("../shared/warnOnce"));
/**
 * A utility to quickly create hooks to access both Session Storage and Local Storage
 */
var createStorageHook = function (type) {
    var storageName = "".concat(type, "Storage");
    if (isClient_1.default && !(0, isAPISupported_1.default)(storageName)) {
        (0, warnOnce_1.default)("".concat(storageName, " is not supported"));
    }
    /**
     * the hook
     */
    return function useStorageCreatedHook(storageKey, defaultValue) {
        if (!isClient_1.default) {
            if (isDevelopment_1.default) {
                (0, warnOnce_1.default)("Please be aware that ".concat(storageName, " could not be available during SSR"));
            }
            return [JSON.stringify(defaultValue), noop_1.default];
        }
        var storage = (window)[storageName];
        var safelySetStorage = (0, react_1.useCallback)(function (valueToStore) {
            try {
                storage.setItem(storageKey, valueToStore);
                // eslint-disable-next-line no-empty
            }
            catch (e) {
            }
        }, [storage, storageKey]);
        var _a = (0, react_1.useState)(function () {
            var _a;
            var valueToStore;
            try {
                valueToStore = (_a = storage.getItem(storageKey)) !== null && _a !== void 0 ? _a : JSON.stringify(defaultValue);
            }
            catch (e) {
                valueToStore = JSON.stringify(defaultValue);
            }
            safelySetStorage(valueToStore);
            return (0, safelyParseJson_1.default)(valueToStore);
        }), storedValue = _a[0], setStoredValue = _a[1];
        var setValue = (0, react_1.useCallback)(function (value) {
            setStoredValue(function (current) {
                var valueToStore = value instanceof Function ? value(current) : value;
                safelySetStorage(JSON.stringify(valueToStore));
                return valueToStore;
            });
        }, [safelySetStorage]);
        return [storedValue, setValue];
    };
};
exports.default = createStorageHook;
