import { type BRHGeolocationPosition } from './types';
export declare const geoStandardOptions: PositionOptions;
/**
 * Checks if two position are equals
 */
export declare const isSamePosition: (current: BRHGeolocationPosition, next: BRHGeolocationPosition) => boolean;
/**
 * Given a position object returns only its properties
 */
export declare const makePositionObj: (position: BRHGeolocationPosition) => {
    timestamp: number;
    coords: {
        latitude: number;
        longitude: number;
        altitude: number | null;
        accuracy: number;
        altitudeAccuracy: number | null;
        heading: number | null;
        speed: number | null;
    };
} | null;
