"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var cache = new Map();
/**
 * A tiny wrapper around console.warn that makes sure the message is only displayed once.
 * Used mainly to avoid polluting server side logs
 * @param message
 */
var warnOnce = function (message) {
    if (cache.has(message))
        return;
    cache.set(message, true);
    // eslint-disable-next-line no-console
    console.warn(message);
};
exports.default = warnOnce;
