import { type CallbackSetter } from './shared/types';
declare const useCookie: (key: string, options?: UseCookieOptions) => Readonly<UseCookieReturn>;
export declare enum CookieSameSite {
    STRICT = "strict",
    LAX = "lax",
    NONE = "none"
}
interface CookieStoreDeleteOptions {
    name?: string;
    domain?: string;
    path?: string;
}
interface CookieBase extends CookieStoreDeleteOptions {
    sameSite?: CookieSameSite;
}
export interface UseCookieOptions extends CookieBase {
    defaultValue?: string;
}
export interface UseCookieReturn {
    cookieValue?: string;
    updateCookie: (nextValue: string) => Promise<void>;
    deleteCookie: () => Promise<void>;
    onError: CallbackSetter<Error>;
}
export default useCookie;
