"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (g && (g = 0, op[0] && (_ = 0)), _) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.CookieSameSite = void 0;
var react_1 = require("react");
var noop_1 = __importDefault(require("./shared/noop"));
var isClient_1 = __importDefault(require("./shared/isClient"));
var isDevelopment_1 = __importDefault(require("./shared/isDevelopment"));
var isAPISupported_1 = __importDefault(require("./shared/isAPISupported"));
var createHandlerSetter_1 = __importDefault(require("./factory/createHandlerSetter"));
var warnOnce_1 = __importDefault(require("./shared/warnOnce"));
var useCookie = function (key, options) {
    var hookNotSupportedResponse = Object.freeze({
        onError: noop_1.default,
        updateCookie: noop_1.default,
        deleteCookie: noop_1.default,
        cookieValue: options === null || options === void 0 ? void 0 : options.defaultValue
    });
    if (!isClient_1.default) {
        if (!isDevelopment_1.default) {
            (0, warnOnce_1.default)('Please be aware that cookieStore could not be available during SSR');
        }
        return hookNotSupportedResponse;
    }
    if (!(0, isAPISupported_1.default)('cookieStore')) {
        (0, warnOnce_1.default)('The current device does not support the \'cookieStore\' API, you should avoid using useCookie');
        return hookNotSupportedResponse;
    }
    var _a = (0, react_1.useState)(), cookieValue = _a[0], setCookieValue = _a[1];
    var _b = (0, createHandlerSetter_1.default)(), onErrorRef = _b[0], setOnErrorRef = _b[1];
    var cookieStoreObject = window.cookieStore;
    var onError = function (err) {
        if (onErrorRef.current != null) {
            onErrorRef.current(err);
        }
    };
    (0, react_1.useEffect)(function () {
        var getInitialValue = function () { return __awaiter(void 0, void 0, void 0, function () {
            var getFunctionResult, err_1;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        _a.trys.push([0, 3, , 4]);
                        return [4 /*yield*/, cookieStoreObject.get(key)];
                    case 1:
                        getFunctionResult = _a.sent();
                        if (getFunctionResult === null || getFunctionResult === void 0 ? void 0 : getFunctionResult.value) {
                            setCookieValue(getFunctionResult.value);
                            return [2 /*return*/];
                        }
                        return [4 /*yield*/, cookieStoreObject.set(__assign({ name: key, value: options === null || options === void 0 ? void 0 : options.defaultValue }, options))];
                    case 2:
                        _a.sent();
                        setCookieValue(options === null || options === void 0 ? void 0 : options.defaultValue);
                        return [2 /*return*/];
                    case 3:
                        err_1 = _a.sent();
                        onError(err_1);
                        return [3 /*break*/, 4];
                    case 4: return [2 /*return*/];
                }
            });
        }); };
        getInitialValue().catch(onError);
    }, []);
    var updateCookie = (0, react_1.useCallback)(function (newValue) { return __awaiter(void 0, void 0, void 0, function () {
        return __generator(this, function (_a) {
            switch (_a.label) {
                case 0: return [4 /*yield*/, cookieStoreObject
                        .set(__assign({ name: key, value: newValue }, options))
                        .then(function () {
                        setCookieValue(newValue);
                    })
                        .catch(onError)];
                case 1:
                    _a.sent();
                    return [2 /*return*/];
            }
        });
    }); }, []);
    var deleteCookie = (0, react_1.useCallback)(function () { return __awaiter(void 0, void 0, void 0, function () {
        return __generator(this, function (_a) {
            switch (_a.label) {
                case 0: return [4 /*yield*/, cookieStoreObject
                        .delete(__assign({ name: key }, options))
                        .then(function () {
                        setCookieValue(undefined);
                    })
                        .catch(onError)];
                case 1:
                    _a.sent();
                    return [2 /*return*/];
            }
        });
    }); }, []);
    return Object.freeze({
        cookieValue: cookieValue,
        updateCookie: updateCookie,
        deleteCookie: deleteCookie,
        onError: setOnErrorRef
    });
};
var CookieSameSite;
(function (CookieSameSite) {
    CookieSameSite["STRICT"] = "strict";
    CookieSameSite["LAX"] = "lax";
    CookieSameSite["NONE"] = "none";
})(CookieSameSite = exports.CookieSameSite || (exports.CookieSameSite = {}));
exports.default = useCookie;
