"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.LOCAL_STORAGE_KEY = void 0;
var react_1 = require("react");
var useMediaQuery_1 = __importDefault(require("./useMediaQuery"));
var useUpdateEffect_1 = __importDefault(require("./useUpdateEffect"));
var useLocalStorage_1 = __importDefault(require("./useLocalStorage"));
var noop_1 = __importDefault(require("./shared/noop"));
var isClient_1 = __importDefault(require("./shared/isClient"));
var isDevelopment_1 = __importDefault(require("./shared/isDevelopment"));
var warnOnce_1 = __importDefault(require("./shared/warnOnce"));
var COLOR_SCHEME_QUERY = '(prefers-color-scheme: dark)';
exports.LOCAL_STORAGE_KEY = 'beautiful-react-hooks-is-dark-mode';
var useDarkMode = function (defaultValue, localStorageKey) {
    var _a;
    if (localStorageKey === void 0) { localStorageKey = exports.LOCAL_STORAGE_KEY; }
    if (!isClient_1.default) {
        if (!isDevelopment_1.default) {
            (0, warnOnce_1.default)('Please be aware that useDarkMode hook could not be available during SSR');
        }
        return Object.freeze({
            toggle: noop_1.default,
            enable: noop_1.default,
            disable: noop_1.default,
            isDarkMode: defaultValue !== null && defaultValue !== void 0 ? defaultValue : false
        });
    }
    var isDarkOS = (0, useMediaQuery_1.default)(COLOR_SCHEME_QUERY);
    var _b = (0, useLocalStorage_1.default)(localStorageKey, (_a = defaultValue !== null && defaultValue !== void 0 ? defaultValue : isDarkOS) !== null && _a !== void 0 ? _a : false), isDarkMode = _b[0], setIsDarkMode = _b[1];
    (0, useUpdateEffect_1.default)(function () {
        setIsDarkMode(isDarkOS);
    }, [isDarkOS]);
    var enable = (0, react_1.useCallback)(function () {
        setIsDarkMode(true);
    }, []);
    var disable = (0, react_1.useCallback)(function () {
        setIsDarkMode(false);
    }, []);
    var toggle = (0, react_1.useCallback)(function () {
        setIsDarkMode(function (prev) { return !prev; });
    }, [setIsDarkMode]);
    return Object.freeze({
        toggle: toggle,
        enable: enable,
        disable: disable,
        isDarkMode: isDarkMode !== null && isDarkMode !== void 0 ? isDarkMode : false
    });
};
exports.default = useDarkMode;
