"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var react_1 = require("react");
var maybeState = function (state, defaultValue) { return (state !== null && state !== void 0 ? state : defaultValue); };
/**
 * Returns a safe state by making sure the given value is not null or undefined
 */
var useDefaultedState = function (defaultValue, initialState) {
    var _a = (0, react_1.useState)(maybeState(initialState, defaultValue)), state = _a[0], setState = _a[1];
    var setStateSafe = (0, react_1.useCallback)(function (nextState) {
        setState(maybeState(nextState, defaultValue));
    }, [setState]);
    return [maybeState(state, defaultValue), setStateSafe];
};
exports.default = useDefaultedState;
