"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
var react_1 = require("react");
var useDragEvents_1 = __importDefault(require("./useDragEvents"));
var defaultOptions = {
    dragImageXOffset: 0,
    dragImageYOffset: 0,
    transferFormat: 'text'
};
var useDrag = function (targetRef, options) {
    if (options === void 0) { options = defaultOptions; }
    var _a = (0, useDragEvents_1.default)(targetRef, true), onDragStart = _a.onDragStart, onDragEnd = _a.onDragEnd;
    var _b = (0, react_1.useState)(false), isDragging = _b[0], setIsDragging = _b[1];
    var opts = __assign(__assign({}, defaultOptions), (options || {}));
    onDragStart(function (event) {
        var _a, _b, _c;
        setIsDragging(true);
        if (opts.dragImage && event.dataTransfer) {
            var img = new Image();
            img.src = opts.dragImage;
            event.dataTransfer.setDragImage(img, (_a = opts.dragImageXOffset) !== null && _a !== void 0 ? _a : 0, (_b = opts.dragImageYOffset) !== null && _b !== void 0 ? _b : 0);
        }
        if (opts.transfer && event.dataTransfer) {
            var data = typeof opts.transfer === 'object' ? JSON.stringify(opts.transfer) : "".concat(opts.transfer);
            event.dataTransfer.setData((_c = opts.transferFormat) !== null && _c !== void 0 ? _c : 'text', data);
        }
    });
    onDragEnd(function () {
        setIsDragging(false);
    });
    return isDragging;
};
exports.default = useDrag;
