import { type RefObject } from 'react';
import { type CallbackSetter } from './shared/types';
export interface UseDragEventsResult {
    onDrag: CallbackSetter<DragEvent>;
    onDrop: CallbackSetter<DragEvent>;
    onDragEnter: CallbackSetter<DragEvent>;
    onDragEnd: CallbackSetter<DragEvent>;
    onDragExit: CallbackSetter<DragEvent>;
    onDragLeave: CallbackSetter<DragEvent>;
    onDragOver: CallbackSetter<DragEvent>;
    onDragStart: CallbackSetter<DragEvent>;
}
/**
 * Returns an object of callback setters to handle the drag-related events.
 * It accepts a DOM ref representing the events target (where attach the events to).
 *
 * Returned callback setters: `onDrag`, `onDrop`, `onDragEnter`, `onDragEnd`, `onDragExit`, `onDragLeave`,
 * `onDragOver`, `onDragStart`;
 */
declare const useDragEvents: <TElement extends HTMLElement>(targetRef: RefObject<TElement>, isDraggable?: boolean) => Readonly<UseDragEventsResult>;
export default useDragEvents;
