import { type RefObject } from 'react';
/**
 * Accepts the reference to an HTML Element and an event name then performs the necessary operations to listen to the event
 * when fired from that HTML Element.
 */
declare const useEvent: <TEvent extends Event, TElement extends HTMLElement = HTMLElement>(target: RefObject<TElement>, eventName: string, options?: AddEventListenerOptions) => import("./shared/types").CallbackSetter<TEvent>;
export default useEvent;
