"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
var useGeolocationState_1 = __importDefault(require("./useGeolocationState"));
var useGeolocationEvents_1 = __importDefault(require("./useGeolocationEvents"));
var geolocationUtils_1 = require("./shared/geolocationUtils");
/**
 * Returns an array where the first item is the geolocation state from the `useGeolocationState` hook and the
 * second one is the object of callback setters from the `useGeolocationEvents` hook.
 * It is intended as a shortcut to those hooks.
 */
var useGeolocation = function (options) {
    if (options === void 0) { options = geolocationUtils_1.geoStandardOptions; }
    var state = (0, useGeolocationState_1.default)(options);
    var events = (0, useGeolocationEvents_1.default)(options);
    return [state, events];
};
exports.default = useGeolocation;
