import { type BRHGeolocationPosition, type BRHGeolocationPositionError } from './shared/types';
export interface UseGeolocationEventsResult {
    isSupported: boolean;
    onChange: (callback: (position: BRHGeolocationPosition) => void) => void;
    onError: (callback: (error: BRHGeolocationPositionError) => void) => void;
}
/**
 * Returns a frozen object of callback setters to handle the geolocation events.<br/>
 * So far, the supported methods are: `onChange`, invoked when the position changes and `onError`, invoked when
 * an error occur while retrieving the position.<br/>
 * The returned object also contains the `isSupported` boolean flag reporting whether the geolocation API is supported.
 */
declare const useGeolocationEvents: (options?: PositionOptions) => Readonly<UseGeolocationEventsResult>;
export default useGeolocationEvents;
