import { type GenericFunction } from './shared/types';
export interface UseIntervalOptions {
    cancelOnUnmount?: boolean;
}
/**
 * An async-utility hook that accepts a callback function and a delay time (in milliseconds), then repeats the
 * execution of the given function by the defined milliseconds.
 */
declare const useInterval: <TCallback extends GenericFunction>(fn: TCallback, milliseconds: number, options?: UseIntervalOptions) => [boolean, () => void];
export default useInterval;
