import { type GenericFunction } from './shared/types';
/**
 * Returns an object wrapping lifecycle hooks such as `useDidMount` or `useWillUnmount`.
 * It is intended as a shortcut to those hooks.
 */
declare const useLifecycle: <TMount extends GenericFunction = GenericFunction, TUnmount extends GenericFunction = GenericFunction>(mount?: TMount | undefined, unmount?: TUnmount | undefined) => {
    onDidMount: import("./shared/types").CallbackSetter<undefined>;
    onWillUnmount: import("./shared/types").CallbackSetter<undefined>;
};
export default useLifecycle;
