"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
var useDidMount_1 = __importDefault(require("./useDidMount"));
var useWillUnmount_1 = __importDefault(require("./useWillUnmount"));
/**
 * Returns an object wrapping lifecycle hooks such as `useDidMount` or `useWillUnmount`.
 * It is intended as a shortcut to those hooks.
 */
var useLifecycle = function (mount, unmount) {
    var onDidMount = (0, useDidMount_1.default)(mount);
    var onWillUnmount = (0, useWillUnmount_1.default)(unmount);
    return { onDidMount: onDidMount, onWillUnmount: onWillUnmount };
};
exports.default = useLifecycle;
