import { type RefObject } from 'react';
import { type CallbackSetter } from './shared/types';
/**
 * A hook that facilitates the implementation of the long press functionality on a given target, supporting both mouse and touch events.
 */
declare const useLongPress: <TElement extends HTMLElement>(target: RefObject<TElement>, duration?: number) => Readonly<UseLongPressResult>;
export interface UseLongPressResult {
    isLongPressing: boolean;
    onLongPressStart: CallbackSetter<void>;
    onLongPressEnd: CallbackSetter<void>;
}
export default useLongPress;
