import { type RefObject } from 'react';
/**
 * Returns a frozen object of callback setters to handle the mouse events.<br/>
 * It accepts a DOM ref representing the events target. <br/>
 * If a target is not provided the events will be globally attached to the document object.
 * <br/>
 * ### Shall the `useMouseEvents` callbacks replace the standard mouse handler props?
 *
 * **They shall not!**<br />
 * **useMouseEvents is meant to be used to abstract more complex hooks that need to control mouse**, for instance:
 * a drag n drop hook.<br />
 * Using useMouseEvents handlers instead of the classic props approach it's just as bad as it sounds since you'll
 * lose the React SyntheticEvent performance boost.<br />
 * If you were doing something like the following:
 */
declare const useMouseEvents: <TElement extends HTMLElement>(targetRef?: RefObject<TElement> | undefined, passive?: boolean) => Readonly<{
    onMouseDown: import("./shared/types").CallbackSetter<MouseEvent>;
    onMouseEnter: import("./shared/types").CallbackSetter<MouseEvent>;
    onMouseLeave: import("./shared/types").CallbackSetter<MouseEvent>;
    onMouseMove: import("./shared/types").CallbackSetter<MouseEvent>;
    onMouseOut: import("./shared/types").CallbackSetter<MouseEvent>;
    onMouseOver: import("./shared/types").CallbackSetter<MouseEvent>;
    onMouseUp: import("./shared/types").CallbackSetter<MouseEvent>;
}>;
export default useMouseEvents;
