"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
var useEvent_1 = __importDefault(require("./useEvent"));
/**
 * Returns a frozen object of callback setters to handle the mouse events.<br/>
 * It accepts a DOM ref representing the events target. <br/>
 * If a target is not provided the events will be globally attached to the document object.
 * <br/>
 * ### Shall the `useMouseEvents` callbacks replace the standard mouse handler props?
 *
 * **They shall not!**<br />
 * **useMouseEvents is meant to be used to abstract more complex hooks that need to control mouse**, for instance:
 * a drag n drop hook.<br />
 * Using useMouseEvents handlers instead of the classic props approach it's just as bad as it sounds since you'll
 * lose the React SyntheticEvent performance boost.<br />
 * If you were doing something like the following:
 */
var useMouseEvents = function (targetRef, passive) {
    var target = targetRef !== null && targetRef !== void 0 ? targetRef : { current: window.document };
    var onMouseDown = (0, useEvent_1.default)(target, 'mousedown', { passive: passive });
    var onMouseEnter = (0, useEvent_1.default)(target, 'mouseenter', { passive: passive });
    var onMouseLeave = (0, useEvent_1.default)(target, 'mouseleave', { passive: passive });
    var onMouseMove = (0, useEvent_1.default)(target, 'mousemove', { passive: passive });
    var onMouseOut = (0, useEvent_1.default)(target, 'mouseout', { passive: passive });
    var onMouseOver = (0, useEvent_1.default)(target, 'mouseover', { passive: passive });
    var onMouseUp = (0, useEvent_1.default)(target, 'mouseup', { passive: passive });
    return Object.freeze({
        onMouseDown: onMouseDown,
        onMouseEnter: onMouseEnter,
        onMouseLeave: onMouseLeave,
        onMouseMove: onMouseMove,
        onMouseOut: onMouseOut,
        onMouseOver: onMouseOver,
        onMouseUp: onMouseUp
    });
};
exports.default = useMouseEvents;
