import { type RefObject } from 'react';
/**
 * Returns the current state (position) of the mouse pointer.
 * It possibly accepts a DOM ref representing the mouse target.
 * If a target is not provided the state will be caught globally.
 */
declare const useMouseState: <TElement extends HTMLElement>(targetRef?: RefObject<TElement> | undefined) => {
    clientX: number;
    clientY: number;
    screenX: number;
    screenY: number;
};
export default useMouseState;
