"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
var react_1 = require("react");
var isClient_1 = __importDefault(require("./shared/isClient"));
var isAPISupported_1 = __importDefault(require("./shared/isAPISupported"));
var warnOnce_1 = __importDefault(require("./shared/warnOnce"));
// eslint-disable-next-line max-len
var errorMessage = 'MutationObserver is not supported, this could happen both because window. MutationObserver is not supported by your current browser or you\'re using the useMutationObserver hook whilst server side rendering.';
var defaultOptions = {
    attributes: true,
    characterData: true,
    childList: true,
    subtree: true
};
var useMutationObserver = function (ref, callback, options) {
    if (options === void 0) { options = defaultOptions; }
    var isSupported = isClient_1.default && (0, isAPISupported_1.default)('MutationObserver');
    if (!isSupported) {
        (0, warnOnce_1.default)(errorMessage);
        return;
    }
    // eslint-disable-next-line consistent-return
    (0, react_1.useEffect)(function () {
        if (ref.current) {
            var observer_1 = new MutationObserver(callback);
            observer_1.observe(ref.current, options);
            return function () { observer_1.disconnect(); };
        }
    }, [callback, options]);
};
exports.default = useMutationObserver;
