"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var react_1 = require("react");
/**
 * Hook, which helps you combine rxjs flow and setState in your component
 */
var useObservable = function (observable, setter) {
    (0, react_1.useEffect)(function () {
        var subscription = observable.subscribe(setter);
        return function () {
            subscription.unsubscribe();
        };
    }, [observable, setter]);
};
exports.default = useObservable;
