export interface UseQueryParamsOptions<TValue extends string[]> {
    initialValue?: TValue;
    replaceState?: boolean;
}
/**
 * Very similar to `useQueryParams`, it eases the process of manipulate a query string that handles multiple values
 */
declare const useQueryParams: <TValue extends string[]>(key: string, options?: UseQueryParamsOptions<TValue>) => [TValue, (nextValue?: TValue | undefined) => void];
export default useQueryParams;
