"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
var react_router_dom_1 = require("react-router-dom");
var react_1 = require("react");
var useDidMount_1 = __importDefault(require("./useDidMount"));
var useURLSearchParams_1 = __importDefault(require("./useURLSearchParams"));
/**
 * Very similar to `useQueryParams`, it eases the process of manipulate a query string that handles multiple values
 */
var useQueryParams = function (key, options) {
    if (options === void 0) { options = {}; }
    var history = (0, react_router_dom_1.useHistory)();
    var params = (0, useURLSearchParams_1.default)();
    var initialisedRef = (0, react_1.useRef)(false);
    var onMount = (0, useDidMount_1.default)();
    var setParam = (0, react_1.useCallback)(function (nextValue) {
        params.delete(key);
        if (nextValue) {
            nextValue.forEach(function (value) {
                params.append(key, value);
            });
        }
        if (options.replaceState) {
            history.replace({ search: params.toString() });
            return;
        }
        history.push({ search: params.toString() });
    }, [options.replaceState, history]);
    onMount(function () {
        if (!params.has(key)) {
            setParam(options.initialValue);
            initialisedRef.current = true;
        }
    });
    return [initialisedRef.current ? params.getAll(key) : options.initialValue, setParam];
};
exports.default = useQueryParams;
