import { type CallbackSetter, type GenericFunction } from './shared/types';
export interface UseRequestAnimationFrameOpts {
    increment?: number;
    startAt?: number;
    finishAt?: number;
}
/**
 * Takes care of running an animating function, provided as the first argument, while keeping track of its progress.
 */
declare const useRequestAnimationFrame: <T extends GenericFunction>(func: T, options?: UseRequestAnimationFrameOpts) => CallbackSetter<void>;
export default useRequestAnimationFrame;
