"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
var react_1 = require("react");
var createHandlerSetter_1 = __importDefault(require("./factory/createHandlerSetter"));
var isClient_1 = __importDefault(require("./shared/isClient"));
var isAPISupported_1 = __importDefault(require("./shared/isAPISupported"));
var noop_1 = __importDefault(require("./shared/noop"));
var warnOnce_1 = __importDefault(require("./shared/warnOnce"));
var defaultOptions = { increment: 1, startAt: 0, finishAt: 100 };
var errorMessage = 'requestAnimationFrame is not supported, this could happen both because ' +
    'window.requestAnimationFrame is not supported by your current browser version or you\'re using the ' +
    'useRequestAnimationFrame hook whilst server side rendering.';
/**
 * Takes care of running an animating function, provided as the first argument, while keeping track of its progress.
 */
var useRequestAnimationFrame = function (func, options) {
    if (options === void 0) { options = defaultOptions; }
    if (!isClient_1.default || !(0, isAPISupported_1.default)('requestAnimationFrame')) {
        (0, warnOnce_1.default)(errorMessage);
        return noop_1.default;
    }
    var opts = __assign(__assign({}, defaultOptions), options);
    var progress = (0, react_1.useRef)(opts.startAt);
    var _a = (0, createHandlerSetter_1.default)(), onFinish = _a[0], setOnFinish = _a[1];
    // eslint-disable-next-line @typescript-eslint/no-use-before-define
    var next = function () { return window.requestAnimationFrame(step); };
    var step = (0, react_1.useCallback)(function () {
        if (progress.current <= opts.finishAt || opts.finishAt === -1) {
            func(progress.current, next);
            progress.current += opts.increment;
        }
        else if (onFinish.current) {
            onFinish.current();
        }
    }, [func, opts.finishAt, opts.increment, progress.current, onFinish]);
    if (progress.current <= opts.startAt) {
        next();
    }
    return setOnFinish;
};
exports.default = useRequestAnimationFrame;
