import { type RefObject } from 'react';
export type DOMRectValues = Pick<DOMRectReadOnly, 'bottom' | 'height' | 'left' | 'right' | 'top' | 'width'>;
/**
 * Uses the ResizeObserver API to observe changes within the given HTML Element DOM Rect.
 * @param elementRef
 * @param debounceTimeout
 * @returns {undefined}
 */
declare const useResizeObserver: <TElement extends HTMLElement>(elementRef: RefObject<TElement>, debounceTimeout?: number) => DOMRectValues | undefined;
export default useResizeObserver;
