declare global {
    interface SpeechRecognitionEvent extends Event {
        results: SpeechRecognitionResultList;
    }
    interface SpeechRecognitionPolyfill {
        start: () => void;
        stop: () => void;
        abort: () => void;
        addEventListener: (event: string, callback: (event: SpeechRecognitionEvent) => void) => void;
        removeEventListener: (event: string, callback: (event: SpeechRecognitionEvent) => void) => void;
        new (): SpeechRecognitionPolyfill;
    }
    interface Window {
        SpeechRecognition?: SpeechRecognitionPolyfill;
        webkitSpeechRecognition?: SpeechRecognitionPolyfill;
    }
}
/**
 * A hook that provides an interface for using the Web Speech API to recognize and transcribe speech in a user's browser.
 */
declare const useSpeechRecognition: () => Readonly<UseSpeechRecognitionResult>;
export interface UseSpeechRecognitionResult {
    isSupported: boolean;
    transcript: string;
    isRecording: boolean;
    startRecording: () => void;
    stopRecording: () => void;
}
export default useSpeechRecognition;
