import { type RefObject } from 'react';
import { type Direction } from './shared/swipeUtils';
/**
 * The options that can be passed to the hook
 */
export interface UseSwipeOptions {
    direction?: 'both' | 'horizontal' | 'vertical';
    threshold?: number;
    preventDefault?: boolean;
    passive?: boolean;
}
/**
 * The result of the hook
 */
export interface SwipeState {
    swiping: boolean;
    direction?: Direction;
    alphaX: number;
    alphaY: number;
    count: number;
}
/**
 * useSwipe hook
 */
declare const useSwipe: <TElement extends HTMLElement>(targetRef?: RefObject<TElement> | undefined, options?: UseSwipeOptions) => SwipeState;
export default useSwipe;
