import { type RefObject } from 'react';
import { type CallbackSetter } from './shared/types';
/**
 * The swipe event state interface
 */
export interface SwipeEventState {
    clientX?: number;
    clientY?: number;
    direction: 'right' | 'left' | 'up' | 'down';
    alphaX: number;
    alphaY: number;
}
/**
 * The result of the hook
 */
interface UseSwipeEventsReturn {
    onSwipeLeft: CallbackSetter<SwipeEventState>;
    onSwipeRight: CallbackSetter<SwipeEventState>;
    onSwipeUp: CallbackSetter<SwipeEventState>;
    onSwipeDown: CallbackSetter<SwipeEventState>;
    onSwipeMove: CallbackSetter<SwipeEventState>;
    onSwipeStart: CallbackSetter<SwipeEventState>;
    onSwipeEnd: CallbackSetter<SwipeEventState>;
}
export interface UseSwipeEventsOpts {
    threshold?: number;
    preventDefault?: boolean;
    passive?: boolean;
}
/**
 * useSwipeEvents
 * @param ref
 * @param options
 */
declare const useSwipeEvents: <TElement extends HTMLElement>(ref?: RefObject<TElement> | undefined, options?: UseSwipeEventsOpts) => Readonly<UseSwipeEventsReturn>;
export default useSwipeEvents;
