/// <reference types="lodash" />
import { type DependencyList } from 'react';
import { type GenericFunction } from './shared/types';
interface ThrottleSettings {
    leading?: boolean | undefined;
    trailing?: boolean | undefined;
}
/**
 * Accepts a function and returns a new throttled yet memoized version of that same function that waits the defined time
 * before allowing the next execution.
 * If time is not defined, its default value will be 250ms.
 */
declare const useThrottledCallback: <TCallback extends GenericFunction>(fn: TCallback, dependencies?: DependencyList, wait?: number, options?: ThrottleSettings) => import("lodash").DebouncedFuncLeading<TCallback>;
export default useThrottledCallback;
