import { type GenericFunction } from './shared/types';
export interface UseTimeoutOptions {
    cancelOnUnmount?: boolean;
}
/**
 * An async-utility hook that accepts a callback function and a delay time (in milliseconds), then delays the
 * execution of the given function by the defined time.
 */
declare const useTimeout: <TCallback extends GenericFunction>(fn: TCallback, milliseconds: number, options?: UseTimeoutOptions) => [boolean, () => void];
export default useTimeout;
