"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
var useEvent_1 = __importDefault(require("./useEvent"));
/**
 * Returns a frozen object of callback setters to handle the touch events.<br/>
 * It accepts a DOM ref representing the events target. <br/>
 * If a target is not provided the events will be globally attached to the document object.
 * <br/>
 * ### Shall the `useTouchEvents` callbacks replace the standard mouse handler props?
 *
 * **They shall not!**<br />
 * **useTouchEvents is meant to be used to abstract more complex hooks that need to control mouse**, for instance:
 * a drag n drop hook.<br />
 * Using useTouchEvents handlers instead of the classic props approach it's just as bad as it sounds since you'll
 * lose the React SyntheticEvent performance boost.<br />
 * If you were doing something like the following:
 *
 */
var useTouchEvents = function (targetRef, passive) {
    var target = targetRef !== null && targetRef !== void 0 ? targetRef : { current: window.document }; // hackish but works
    var onTouchStart = (0, useEvent_1.default)(target, 'touchstart', { passive: passive });
    var onTouchEnd = (0, useEvent_1.default)(target, 'touchend', { passive: passive });
    var onTouchCancel = (0, useEvent_1.default)(target, 'touchcancel', { passive: passive });
    var onTouchMove = (0, useEvent_1.default)(target, 'touchmove', { passive: passive });
    return Object.freeze({
        onTouchStart: onTouchStart,
        onTouchEnd: onTouchEnd,
        onTouchCancel: onTouchCancel,
        onTouchMove: onTouchMove
    });
};
exports.default = useTouchEvents;
