"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
var react_1 = require("react");
var useTouchEvents_1 = __importDefault(require("./useTouchEvents"));
/**
 * Returns the current touches from the touch move event.
 * It possibly accepts a DOM ref representing the mouse target.
 * If a target is not provided the state will be caught globally.
 */
var useTouchState = function (targetRef) {
    // eslint-disable-next-line @typescript-eslint/consistent-type-assertions
    var _a = (0, react_1.useState)({ length: 0 }), state = _a[0], setState = _a[1];
    var _b = (0, useTouchEvents_1.default)(targetRef), onTouchStart = _b.onTouchStart, onTouchMove = _b.onTouchMove;
    onTouchStart(function (event) {
        setState(event.touches);
    });
    onTouchMove(function (event) {
        setState(event.touches);
    });
    return state;
};
exports.default = useTouchState;
