"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
var react_1 = require("react");
var isFunction_1 = __importDefault(require("./shared/isFunction"));
var createHandlerSetter_1 = __importDefault(require("./factory/createHandlerSetter"));
/**
 * Returns a callback setter for a callback to be performed when the component will unmount.
 */
var useWillUnmount = function (callback) {
    var mountRef = (0, react_1.useRef)(false);
    var _a = (0, createHandlerSetter_1.default)(callback), handler = _a[0], setHandler = _a[1];
    (0, react_1.useLayoutEffect)(function () {
        mountRef.current = true;
        return function () {
            if ((0, isFunction_1.default)(handler === null || handler === void 0 ? void 0 : handler.current) && mountRef.current) {
                handler.current();
            }
        };
    }, []);
    return setHandler;
};
exports.default = useWillUnmount;
